#ifndef _AMMOS_P_TYPES_H
#define _AMMOS_P_TYPES_H

/*++++ FILE DESCRIPTION +++++++++++++++++++++++++++++++++++++++++++++++++++++++

COPYRIGHT:          (c) 2000 Rohde & Schwarz, Munich

PROJECT:            AMMOS

MODULE:             $Workfile: ammos_p_types.h $

ABBREVIATION:       None

COMPILER:           ANSI-C compliant

LANGUAGE:           ANSI-C

AUTHORS:            G. Condra, Tel. 3372 @ R&S
                    M. Obermeier, Matthias.Obermeier@rsd.rsd.de

ABSTRACT:           Definition of project data types.

PREMISES:           None

HISTORY:
Number  Date        Who             What
0       22/01/1999  G. CONDRA       Creation
1       14.10.1999  M. Obermeier    Neuer Modulname und Modulkopf
2       26.10.1999  M. Obermeier    Vollstaendige Ueberarbeitung, ptypENUM 
                                    entfernt, ptypFLOAT_SP und eigene 
                                    Grenzwerte fuer jeden definierten project
                                    'type' neu aufgenommen
3       12.11.1999  M. Obermeier    Neue Definition von ptypINT_MAX und 
                                    ptypINT_MIN
4       20.12.1999  M. Obermeier    Ersatz von allen ptyp..._MIN/MAX durch 
                                    pk..._MIN/MAX
6       13.01.2000  M. Obermeier    Definition von pkTRUE und pkFALSE. 
7       19.01.2000  M. Obermeier    Kommentare ergaenzt, ptypPACKEDCHAR neu 
                                    aufgenommen und alle Definitionen, die 
                                    sich nicht direkt auf einen project type 
                                    beziehen, entfernt.
8       21.01.2000  M. Obermeier    pkUINT64_MAX, ptypUINT64 und
                                    ptypBIG_TIME ergaenzt.
9       26.01.2000  M. Obermeier    ptypEX ergaenzt.
10      03.02.2000  M. Obermeier    Umbenennung: ptypBIG_TIME -> ptypBIGTIME
11      25.02.2000  M. Obermeier    Abbruch der Uebersetzung bei int < 32 bit, 
                                    ptypFAULTSTRUCT und 
                                    pkMAX_LEN_OF__FAULT_DESCRIPTION_STRING 
                                    ergaenzt.
12      07.03.2000  M. Obermeier    Makro pSIZEOF() ergaenzt, Definition von
                                    pkMAX_LEN_OF__FAULT_DESCRIPTION_STRING
                                    und ptypFAULTSTRUCT geaendert.
13      03.04.2000  M. Obermeier    pkMAX_LEN_OF__VERSION_STRING, 
                                    ptypMSG__QUERY_STATUS_BASIC_CONFIRMATION
                                    und 
                                    ptypMSG__QUERY_STATUS_VERSION_CONFIRMATION
                                    ergaenzt.
14      26.06.2001  R. Ruhland      ptypUINT64 Definition f. vxWorks ergaenzt
                                    erleichtert TimeDriver-Implementation
                                    unter VxWorks
15      27.11.2001  G. Schreiber    ptypUINT64 entfernt, siehe CR #186
                                    ptypFAULTSTRUCT entsprechend modifiziert
                                    


REVIEW:
Number  Date        Who
0       ...         Names of all participiants

LAST MODIFICATION:  $Date: 21/07/04 15:28 $
                    $Author: Hisch_m $

------ End of file description ----------------------------------------------*/


/*++++ INCLUDE FILES ++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*  Nested includes are non preferred. */
#include <limits.h>
#include <float.h>
/*---- End of include files -------------------------------------------------*/


/*++++ GLOBAL DEFINES +++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/*++++ Define limits for project types ++++++++++++++++++++++++++++++++++++++*/
/* Limits for 32-bit integer types corresponding to the definitions in 
   limits.h */
#define pkINT_MAX   2147483647   
#define pkINT_MIN (-2147483647 - 1) /* -2147483648 */
#define pkCHAR_MAX  pkINT_MAX
#define pkCHAR_MIN  pkINT_MIN
#define pkUINT_MAX  0xffffffffU     /*  4294967295 */

/* Characteristics for 32-bit IEEE 754/854 compatible single precision floating
   point format corresponding to the definitions in float.h */
#define pkFLT_SP_RADIX     2
#define pkFLT_SP_MANT_DIG  24
#define pkFLT_SP_MIN_EXP (-125)
#define pkFLT_SP_MAX_EXP   128
/*---------------------------------------------------------------------------*/

/*++++ Definition of the constants pkTRUE and pkFALSE for ptypBOOL ++++++++++*/
#define pkFALSE ((ptypBOOL)0)
#define pkTRUE  ((ptypBOOL)1)
/*---------------------------------------------------------------------------*/

/*++++ Define limit for length of Fault Descripton String +++++++++++++++++++*/
/* This limits the maximal number of (8-bit) characters in the packed 
   FaultString (see declaration of ptypFAULTSTRUCT below) */

#define pkMAX_LEN_OF__FAULT_DESCRIPTION_STRING 80
/*---------------------------------------------------------------------------*/

/*++++ Define limit for length of Version Descripton String +++++++++++++++++++*/
/* This limits the maximal number of (8-bit) characters in the packed 
   VersionString (see declaration of ptypMSG_QUERY_STASTUS_VERSION_CONFIRMATION
   below) */

#define pkMAX_LEN_OF__VERSION_STRING 80
/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Define a Makro that calculates the Size of an Object (a) in Octets 
   (8-bit bytes). The Type of the Result is ptypUINT. */ 
#if CHAR_BIT == 8
  #define pSIZEOF(a) ((ptypUINT)sizeof(a))

#elif CHAR_BIT == 16
  #define pSIZEOF(a) ((ptypUINT)(2*sizeof(a)))

#elif CHAR_BIT == 32
  #define pSIZEOF(a) ((ptypUINT)(4*sizeof(a)))

#else
  #error Fault defining 'pSIZEOF()'.
#endif
/*---------------------------------------------------------------------------*/

/*++++ Stop compilation on platforms with less than 32 bit int's ++++++++++++*/
#if INT_MAX < pkINT_MAX
  #error Integer type (int) has less than 32 bits. This would lead to \
         problems with some enums in other project files which contain \
         32 bit wide members. Compilation halted.
#endif
/*---------------------------------------------------------------------------*/

/*---- End of global defines ------------------------------------------------*/


/*++++ GLOBAL TYPES DECLARATION +++++++++++++++++++++++++++++++++++++++++++++*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*  Define a project 'type' for 'character'. The 8 LSBits of this 32-bit type 
    contain one 8-bit character. */
#if CHAR_MAX == pkCHAR_MAX
  #if CHAR_MIN == pkCHAR_MIN
    typedef char ptypCHAR;
  #else
    #error Fault assigning typedef for 'ptypCHAR' (character).
  #endif

#elif SHRT_MAX == pkCHAR_MAX
  #if SHRT_MIN == pkCHAR_MIN
    typedef short ptypCHAR;
  #else
    #error Fault assigning typedef for 'ptypCHAR' (character).
  #endif

#elif INT_MAX == pkCHAR_MAX
  #if INT_MIN == pkCHAR_MIN
    typedef int ptypCHAR;
  #else
    #error Fault assigning typedef for 'ptypCHAR' (character).
  #endif

#elif LONG_MAX == pkCHAR_MAX
  #if LONG_MIN == pkCHAR_MIN
    typedef long ptypCHAR;
  #else
    #error Fault assigning typedef for 'ptypCHAR' (character).
  #endif

#else
  #error Fault assigning typedef for 'ptypCHAR' (character).
#endif
/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*  Define a project 'type' for 'signed integer' numbers. */
#if SHRT_MAX == pkINT_MAX
  #if SHRT_MIN == pkINT_MIN
    typedef short ptypINT;
  #else
    #error Fault assigning typedef for 'ptypINT' (signed integer).
  #endif

#elif INT_MAX == pkINT_MAX
  #if INT_MIN == pkINT_MIN
    typedef int ptypINT;
  #else
    #error Fault assigning typedef for 'ptypINT' (signed integer).
  #endif

#elif LONG_MAX == pkINT_MAX
  #if LONG_MIN == pkINT_MIN
    typedef long ptypINT;
  #else
    #error Fault assigning typedef for 'ptypINT' (signed integer).
  #endif

#else
  #error Fault assigning typedef for 'ptypINT' (signed integer).
#endif
/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*  Define a project 'type' for 'unsigned integer' numbers. */
#if USHRT_MAX == pkUINT_MAX
  typedef unsigned short ptypUINT;

#elif UINT_MAX == pkUINT_MAX
  typedef unsigned int ptypUINT;

#elif ULONG_MAX == pkUINT_MAX
  typedef unsigned long ptypUINT;

#else
  #error Fault assigning typedef for 'ptypUINT' (unsigned integer).
#endif
/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Define a project 'type' for IEEE 754/854 compatible 32-bit floating point 
   format */
#if FLT_RADIX == pkFLT_SP_RADIX
  #if (FLT_MANT_DIG == pkFLT_SP_MANT_DIG) && \
      (FLT_MIN_EXP ==  pkFLT_SP_MIN_EXP) && \
      (FLT_MAX_EXP ==  pkFLT_SP_MAX_EXP)
    typedef float ptypFLOAT_SP;
  
  #elif (DBL_MANT_DIG == pkFLT_SP_MANT_DIG) && \
        (DBL_MIN_EXP ==  pkFLT_SP_MIN_EXP) && \
        (DBL_MAX_EXP ==  pkFLT_SP_MAX_EXP)
    typedef double ptypFLOAT_SP;
  
  #else
    #error Fault assigning typedef for 'ptypFLOAT_SP' \
           (floating point single precision).
  #endif
#else
  #error Fault assigning typedef for 'ptypFLOAT_SP' \
         (floating point single precision).
#endif
/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*  Define a project 'type' for 'boolean'. */
#if USHRT_MAX == pkUINT_MAX
  typedef unsigned short ptypBOOL;

#elif UINT_MAX == pkUINT_MAX
  typedef unsigned int ptypBOOL;

#elif ULONG_MAX == pkUINT_MAX
  typedef unsigned long ptypBOOL;

#else
  #error Fault assigning typedef for 'ptypBOOL' (boolean).
#endif
/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Define a project 'type' which may contain up to four 8-bit characters
   'packed' into a 32-bit word.
   If the original four charcters form a (null-terminated) C-string,
   then the first character of the string is located to the 8-LSBits of
   the packed char, the next char to the next 8-Bits of the packed char
   and so on.
                       
   EXAMPLE:
      (null-terminated) string "abc" maps to:
      32-bit word:   |    '\0'    |    'c'    |    'b'    |    'a'    | 
                     31(MSBit)  24 23       16 15        8 7          0(LSBit)
*/

#if CHAR_MAX == pkCHAR_MAX
  #if CHAR_MIN == pkCHAR_MIN
    typedef char ptypPACKEDCHAR;
  #else
    #error Fault assigning typedef for 'ptypPACKEDCHAR'.
  #endif

#elif SHRT_MAX == pkCHAR_MAX
  #if SHRT_MIN == pkCHAR_MIN
    typedef short ptypPACKEDCHAR;
  #else
    #error Fault assigning typedef for 'ptypPACKEDCHAR'.
  #endif

#elif INT_MAX == pkCHAR_MAX
  #if INT_MIN == pkCHAR_MIN
    typedef int ptypPACKEDCHAR;
  #else
    #error Fault assigning typedef for 'ptypPACKEDCHAR'.
  #endif

#elif LONG_MAX == pkCHAR_MAX
  #if LONG_MIN == pkCHAR_MIN
    typedef long ptypPACKEDCHAR;
  #else
    #error Fault assigning typedef for 'ptypPACKEDCHAR'.
  #endif

#else
  #error Fault assigning typedef for 'ptypPACKEDCHAR'.
#endif
/*---------------------------------------------------------------------------*/
 
/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/*  Define a project 'type' to contain a complex number made up of
    two 16-bit (signed)integer numbers.
    The 16-MSBits of the packed complex type contain the real part of the
    complex number.
    The 16-LSBits of the packed complex type contain the imaginary part of the
    complex number.
*/

#if USHRT_MAX == pkUINT_MAX
  typedef unsigned short ptypPACKEDCOMPLEXI16;

#elif UINT_MAX == pkUINT_MAX
  typedef unsigned int ptypPACKEDCOMPLEXI16;

#elif ULONG_MAX == pkUINT_MAX
  typedef unsigned long ptypPACKEDCOMPLEXI16;

#else
  #error Fault assigning typedef for 'ptypPACKEDCOMPLEXI16' \
         (packed complex_int16).
#endif
/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Define a project 'type' for the representation of 'time'. Time is
   represented as a 64-bit count of microseconds elapsed since 01.01.1970,
   0:00 h UTC (UTC as described in: "RECOMMENDATION ITU-R TF.460-5, 
   STANDARD-FREQUENCY and TIME-SIGNAL EMISSIONS, 1970-1974-1978-1982-1986-1997"). 
   This 64-bit count of microseconds rolls over in over 500000 years!
   The ptype is implemented as a union whose members may vary on 
   differing platforms. */
typedef union
{
  /* Structure of two 32-bit values for use on all 32-bit platforms */
  struct
  {
    ptypUINT     uintTime_LoOrderBits; /* 32 LSBits of the microseconds count */

    ptypUINT     uintTime_HiOrderBits; /* 32 MSBits of the microseconds count */
  
  } structTimeInTwoWords;

  /* The following array is only a 'dummy' which should never be acessed. It's 
     use is to force the compiler to hold the two members of the above struct
     in adjacent memory words. */
  ptypUINT       uintTimeAsArray[2];

#if  ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)) && _EXTENSION_WRS == 1 && CPU==PENTIUM
  /* only true for VxWorks Pentium GNU-Compiler */
  /* On platforms supporting 64-bit integer types an additional 64-bit word
     for the entire microsec count is declared. */
  
  unsigned long long uint64TimeInOneWord;

#endif
} ptypBIGTIME;
/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Define a 'project type' for the return values of functions returning 
   fault codes. */
typedef ptypINT ptypEX;
/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Define a 'project type' for fault Messages. */

typedef struct
{
  
  ptypUINT     uintFaultDeviceNA;
  ptypUINT     uintFaultComponentID;
  ptypBIGTIME  bigtimeTimestamp;
  ptypEX       exFaultId;
  ptypINT      intFaultCat;
  /* Fault String containing up to 80 8-bit characters corresponding to 20 
     packed characters (ptypPACKEDCHAR). */
  ptypPACKEDCHAR 
    packedcharFaultString[pkMAX_LEN_OF__FAULT_DESCRIPTION_STRING /
      pSIZEOF(ptypPACKEDCHAR)];

} ptypFAULTSTRUCT;
/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Define a 'project type' for the confirmation of a query status basic
   indication. */
typedef struct
{
  ptypBOOL boolFaultOccurred;  /* Since last query */
} ptypMSG__QUERY_STATUS_BASIC_CONFIRMATION;
/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/* Define a 'project type' for the confirmation of a query status version
   indication. */
typedef struct
{
  ptypBOOL boolFaultOccurred; /* Since last query */

  ptypBIGTIME bigtimeTime; /* Time when message is confirmed */

  ptypUINT uintVersionNumber;

  /* Version string (terminated). */
  ptypPACKEDCHAR
    packedcharVersionString[pkMAX_LEN_OF__VERSION_STRING / 
      pSIZEOF(ptypPACKEDCHAR)];

} ptypMSG__QUERY_STATUS_VERSION_CONFIRMATION;

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
/** Define a macro for definition of enum types. This shall be used
 *  where enum types are used in FlexComm messages. The macro will only define
 *  a type, based on the name of an enumeration, if the enumerator
 *  values are represented as 32-bit numbers on the current platform.
 *  Otherwise the desired type will be defined as of type ptypINT
 *
 *  example:
 *      this enum type (typeBase) is defined in the context of the user's header file
 *
 *      enum eBase {
 *           ebase1 = 256,
 *           ebase2 = 512
 *      };
 *      pmtypMSG_ENUM(enum eBase, typBase);   <- this is really new, user calls makro to define an enum-type !
 */
#if (INT_MAX==pkINT_MAX)
  #if (INT_MIN==pkINT_MIN)
    #define pmtypMSG_ENUM(enumerator, enumtyp) typedef enum enumerator enumtyp
  #endif
#endif
#ifndef pmtypMSG_ENUM
  #warning platform deviates from standard size for enumerator, enum types are replaced by ptypINT
  #define pmtypMSG_ENUM(enumerator, enumtyp) typedef ptypINT enumtyp
#endif

/*---------------------------------------------------------------------------*/

/*---- End of global types declaration --------------------------------------*/


/*++++ AUTOMATICALLY GENERATED VERSION HISTORY ++++++++++++++++++++++++++++++++

$Log: /EM050/System/Firmware/Mainproz/Incappl/ammos_p_types.h $
 * 
 * 5     21/07/04 15:28 Hisch_m
 * neuer FlexLink LAN Treiber + FL Replay eingebaut
 * 
 * 4     26/03/04 13:18 Hisch_m
 * 
 * 3     8.08.02 14:38 Hisch_m
 * BIGTIME jetzt ohne UINT64, wegen byteorder
 * 
 * 2     14.05.02 16:49 Hisch_m
 * Umbau wegen GNU Compiler und neuer OSE Version 4.4.1
 * 
 * 1     12.02.02 15:09 Hisch_m
 * 
 * 5     29.11.01 14:52 Schrei_g
 * Projekttyp ptypUINT64 entfernt
 * Projekttyp ptypBIGTIME fr VxWorks modifiziert
 * 
 * 4     26.06.01 14:09 Ruhland
 * ptypUINT64 Definition f. vxWorks ergaenzt erleichtert 
 * TimeDriver-Implementation unter VxWorks
 * 
 * 3     26.07.00 8:21 Wietho_m
 * angepat aus I:\AMMOS\Allgemeine_Informationen\Projektdateien\include
 * 
 * 2     3.04.00 15:08 Oberm_ma
 * pkMAX_LEN_OF__VERSION_STRING, pypMSG__QUERY_STATUS_BASIC_CONFIRMATION
 * und ptypMSG__QUERY_STATUS_VERSION_CONFIRMATION ergaenzt.
 * 
 * 1     27.03.00 12:43 Modlich
 * Globale Vereinbarungen. Ausgeliefert in Version 1.00 an SEL.
 * 
 * 15    7.03.00 18:03 Oberm_ma
 * Makro pSIZEOF() ergaenzt, Definition von
 * pkMAX_LEN_OF__FAULT_DESCRIPTION_STRING und ptypFAULTSTRUCT geaendert.
 * 
 * 14    25.02.00 13:58 Oberm_ma
 * Syntaktischen Fehler behoben.
 * 
 * 13    25.02.00 10:06 Oberm_ma
 * Abbruch der Uebersetzung bei int < 32 bit und ptypFAULTSTRUCT ergaenzt.
 * 
 * 12    11.02.00 17:18 Oberm_ma
 * Definition von UTC im Kommentar zu ptypBIGTIME ergaenzt.
 * 
 * 11    3.02.00 14:35 Oberm_ma
 * ptypBIG_TIME umbenannt in ptypBIGTIME.
 * 
 * 10    26.01.00 14:33 Oberm_ma
 * Datei ergaenzt.
 * 
 * 9     26.01.00 10:07 Oberm_ma
 * Fehlermeldung bei ptypPACKEDCHAR korrigiert.
 * 
 * 8     26.01.00 9:42 Oberm_ma
 * Version mit ptypUINT64 und ptypBIG_TIME eingecheckt.
 * 
 * 7     19.01.00 16:04 Oberm_ma
 * Kommentare ueberarbeitet.
 * 
 * 6     19.01.00 14:00 Oberm_ma
 * Datei erweitert und einige defines entfernt.
 * 
 * 5     13.01.00 16:54 Oberm_ma
 * Datei erweitert.
 * 
 * 4     23.12.99 14:10 Oberm_ma
 * Ueberarbeitet, Modullayout an neue Richtlinien angepasst.

------ End of automatically generated version history -----------------------*/

#endif /* ifndef for file (multi)inclusion lock. */
/****** End of file. *********************************************************/
